/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.impl;

import com.sun.lwuit.Component;
import com.sun.lwuit.Display;
import com.sun.lwuit.Form;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.RGBImage;
import com.sun.lwuit.animations.Animation;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.geom.Rectangle;
import java.io.IOException;
import java.io.InputStream;

public abstract class LWUITImplementation {
    public static final int KEYBOARD_TYPE_UNKNOWN = 0;
    public static final int KEYBOARD_TYPE_NUMERIC = 1;
    public static final int KEYBOARD_TYPE_QWERTY = 2;
    public static final int KEYBOARD_TYPE_VIRTUAL = 3;
    public static final int KEYBOARD_TYPE_HALF_QWERTY = 4;
    private Form currentForm;
    private static Object displayLock;
    private Animation[] paintQueue = new Animation[50];
    private Animation[] paintQueueTemp = new Animation[50];
    private int paintQueueFill = 0;
    private Graphics lwuitGraphics;
    private int[] xPointerEvent = new int[1];
    private int[] yPointerEvent = new int[1];

    public abstract void init(Object var1);

    public void playDialogSound(int type) {
    }

    public void vibrate(int duration) {
    }

    public void flashBacklight(int duration) {
    }

    public abstract int getDisplayWidth();

    public abstract int getDisplayHeight();

    public boolean handleEDTException(Throwable err) {
        return false;
    }

    public abstract void editString(Component var1, int var2, int var3, String var4);

    public void saveTextEditingState() {
    }

    public boolean hasPendingPaints() {
        return this.paintQueueFill != 0;
    }

    public Object getVideoControl(Object player) {
        return null;
    }

    public int numAlphaLevels() {
        return 255;
    }

    public int numColors() {
        return 65536;
    }

    protected void paintOverlay(Graphics g) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintDirty() {
        int size = 0;
        Object object = displayLock;
        synchronized (object) {
            size = this.paintQueueFill;
            Animation[] array = this.paintQueue;
            this.paintQueue = this.paintQueueTemp;
            this.paintQueueTemp = array;
            this.paintQueueFill = 0;
        }
        if (size > 0) {
            Graphics wrapper = this.getLWUITGraphics();
            int topX = this.getDisplayWidth();
            int topY = this.getDisplayHeight();
            int bottomX = 0;
            int bottomY = 0;
            for (int iter = 0; iter < size; ++iter) {
                Animation ani = this.paintQueueTemp[iter];
                this.paintQueueTemp[iter] = null;
                wrapper.translate(-wrapper.getTranslateX(), -wrapper.getTranslateY());
                wrapper.setClip(0, 0, this.getDisplayWidth(), this.getDisplayHeight());
                if (ani instanceof Component) {
                    Component cmp = (Component)ani;
                    Rectangle dirty = cmp.getDirtyRegion();
                    if (dirty != null) {
                        wrapper.setClip(dirty.getX(), dirty.getY(), dirty.getSize().getWidth(), dirty.getSize().getHeight());
                        cmp.setDirtyRegion(null);
                    }
                    cmp.paintComponent(wrapper);
                    int cmpAbsX = cmp.getAbsoluteX() + cmp.getScrollX();
                    topX = Math.min(cmpAbsX, topX);
                    bottomX = Math.max(cmpAbsX + cmp.getWidth(), bottomX);
                    int cmpAbsY = cmp.getAbsoluteY() + cmp.getScrollY();
                    topY = Math.min(cmpAbsY, topY);
                    bottomY = Math.max(cmpAbsY + cmp.getHeight(), bottomY);
                    continue;
                }
                bottomX = this.getDisplayWidth();
                bottomY = this.getDisplayHeight();
                topX = 0;
                topY = 0;
                ani.paint(wrapper);
            }
            this.paintOverlay(wrapper);
            this.flushGraphics(topX, topY, bottomX - topX, bottomY - topY);
        }
    }

    public abstract void flushGraphics(int var1, int var2, int var3, int var4);

    public abstract void flushGraphics();

    protected Graphics getLWUITGraphics() {
        return this.lwuitGraphics;
    }

    public void setLWUITGraphics(Graphics g) {
        this.lwuitGraphics = g;
    }

    public void setDisplayLock(Object lock) {
        displayLock = lock;
    }

    public Object getDisplayLock() {
        return displayLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repaint(Animation cmp) {
        Object object = displayLock;
        synchronized (object) {
            for (int iter = 0; iter < this.paintQueueFill; ++iter) {
                Animation ani = this.paintQueue[iter];
                if (ani != cmp) continue;
                return;
            }
            if (this.paintQueueFill >= this.paintQueue.length) {
                System.out.println("Warning paint queue size exceeded, please watch the amount of repaint calls");
                return;
            }
            this.paintQueue[this.paintQueueFill] = cmp;
            ++this.paintQueueFill;
            displayLock.notify();
        }
    }

    public abstract void getRGB(Object var1, int[] var2, int var3, int var4, int var5, int var6, int var7);

    public Object createImage(int[] rgb, int width, int height) {
        return new RGBImage(rgb, width, height);
    }

    public abstract Object createImage(String var1) throws IOException;

    public abstract Object createImage(InputStream var1) throws IOException;

    public abstract Object createMutableImage(int var1, int var2, int var3);

    public boolean isAlphaMutableImageSupported() {
        return false;
    }

    public abstract Object createImage(byte[] var1, int var2, int var3);

    public abstract int getImageWidth(Object var1);

    public abstract int getImageHeight(Object var1);

    public abstract Object scale(Object var1, int var2, int var3);

    private static int round(double d) {
        double f = Math.floor(d);
        double c = Math.ceil(d);
        if (c - d < d - f) {
            return (int)c;
        }
        return (int)f;
    }

    public Object rotate(Object image, int degrees) {
        int width = this.getImageWidth(image);
        int height = this.getImageHeight(image);
        int[] arr = new int[width * height];
        int[] dest = new int[arr.length];
        this.getRGB(image, arr, 0, 0, 0, width, height);
        int centerX = width / 2;
        int centerY = height / 2;
        double radians = Math.toRadians(-degrees);
        double cosDeg = Math.cos(radians);
        double sinDeg = Math.sin(radians);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int destOffset;
                int x2 = LWUITImplementation.round(cosDeg * (double)(x - centerX) - sinDeg * (double)(y - centerY) + (double)centerX);
                int y2 = LWUITImplementation.round(sinDeg * (double)(x - centerX) + cosDeg * (double)(y - centerY) + (double)centerY);
                if (x2 < 0 || y2 < 0 || x2 >= width || y2 >= height || (destOffset = x2 + y2 * width) < 0 || destOffset >= dest.length) continue;
                dest[x + y * width] = arr[destOffset];
            }
        }
        return this.createImage(dest, width, height);
    }

    public abstract int getSoftkeyCount();

    public abstract int[] getSoftkeyCode(int var1);

    public abstract int getClearKeyCode();

    public abstract int getBackspaceKeyCode();

    public abstract int getBackKeyCode();

    public abstract int getGameAction(int var1);

    public abstract int getKeyCode(int var1);

    public abstract boolean isTouchDevice();

    public void setCurrentForm(Form f) {
        this.currentForm = f;
    }

    public void confirmControlView() {
    }

    public Form getCurrentForm() {
        return this.currentForm;
    }

    public boolean isTranslationSupported() {
        return false;
    }

    public void translate(Object graphics, int x, int y) {
    }

    public int getTranslateX(Object graphics) {
        return 0;
    }

    public int getTranslateY(Object graphics) {
        return 0;
    }

    public abstract int getColor(Object var1);

    public abstract void setColor(Object var1, int var2);

    public abstract void setAlpha(Object var1, int var2);

    public abstract int getAlpha(Object var1);

    public boolean isAlphaGlobal() {
        return false;
    }

    public boolean isAntiAliasingSupported() {
        return false;
    }

    public boolean isAntiAliasedTextSupported() {
        return false;
    }

    public void setAntiAliased(Object graphics, boolean a) {
    }

    public boolean isAntiAliased(Object graphics) {
        return false;
    }

    public void setAntiAliasedText(Object graphics, boolean a) {
    }

    public boolean isAntiAliasedText(Object graphics) {
        return false;
    }

    public abstract void setNativeFont(Object var1, Object var2);

    public Rectangle getClipRect(Object graphics) {
        return new Rectangle(this.getClipX(graphics), this.getClipY(graphics), new Dimension(this.getClipWidth(graphics), this.getClipHeight(graphics)));
    }

    public abstract int getClipX(Object var1);

    public abstract int getClipY(Object var1);

    public abstract int getClipWidth(Object var1);

    public abstract int getClipHeight(Object var1);

    public void setClipRect(Object graphics, Rectangle rect) {
        Dimension d = rect.getSize();
        this.setClip(graphics, rect.getX(), rect.getY(), d.getWidth(), d.getHeight());
    }

    public abstract void setClip(Object var1, int var2, int var3, int var4, int var5);

    public void clipRect(Object graphics, Rectangle rect) {
        Dimension d = rect.getSize();
        this.clipRect(graphics, rect.getX(), rect.getY(), d.getWidth(), d.getHeight());
    }

    public abstract void clipRect(Object var1, int var2, int var3, int var4, int var5);

    public abstract void drawLine(Object var1, int var2, int var3, int var4, int var5);

    public abstract void fillRect(Object var1, int var2, int var3, int var4, int var5);

    public abstract void drawRect(Object var1, int var2, int var3, int var4, int var5);

    public abstract void drawRoundRect(Object var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public abstract void fillRoundRect(Object var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public abstract void fillArc(Object var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public abstract void drawArc(Object var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public abstract void drawString(Object var1, String var2, int var3, int var4);

    public abstract void drawImage(Object var1, Object var2, int var3, int var4);

    public void drawImageRotated(Object graphics, Object img, int x, int y, int degrees) {
    }

    public boolean isRotationDrawingSupported() {
        return false;
    }

    public void fillTriangle(Object graphics, int x1, int y1, int x2, int y2, int x3, int y3) {
        this.fillPolygon(graphics, new int[]{x1, x2, x3}, new int[]{y1, y2, y3}, 3);
    }

    public abstract void drawRGB(Object var1, int[] var2, int var3, int var4, int var5, int var6, int var7, boolean var8);

    public abstract Object getNativeGraphics();

    public abstract Object getNativeGraphics(Object var1);

    public abstract int charsWidth(Object var1, char[] var2, int var3, int var4);

    public abstract int stringWidth(Object var1, String var2);

    public abstract int charWidth(Object var1, char var2);

    public abstract int getHeight(Object var1);

    public abstract Object getDefaultFont();

    public int getFace(Object nativeFont) {
        return 0;
    }

    public int getSize(Object nativeFont) {
        return 0;
    }

    public int getStyle(Object nativeFont) {
        return 0;
    }

    public abstract Object createFont(int var1, int var2, int var3);

    protected void keyPressed(int keyCode) {
        Display.getInstance().keyPressed(keyCode);
    }

    protected void keyReleased(int keyCode) {
        Display.getInstance().keyReleased(keyCode);
    }

    protected void pointerDragged(int x, int y) {
        this.xPointerEvent[0] = x;
        this.yPointerEvent[0] = y;
        Display.getInstance().pointerDragged(this.xPointerEvent, this.yPointerEvent);
    }

    protected void pointerPressed(int x, int y) {
        this.xPointerEvent[0] = x;
        this.yPointerEvent[0] = y;
        Display.getInstance().pointerPressed(this.xPointerEvent, this.yPointerEvent);
    }

    protected void pointerReleased(int x, int y) {
        this.xPointerEvent[0] = x;
        this.yPointerEvent[0] = y;
        Display.getInstance().pointerReleased(this.xPointerEvent, this.yPointerEvent);
    }

    protected void pointerHover(int[] x, int[] y) {
        Display.getInstance().pointerHover(x, y);
    }

    protected void pointerHover(int x, int y) {
        this.xPointerEvent[0] = x;
        this.yPointerEvent[0] = y;
        Display.getInstance().pointerHover(this.xPointerEvent, this.yPointerEvent);
    }

    protected void pointerDragged(int[] x, int[] y) {
        Display.getInstance().pointerDragged(x, y);
    }

    protected void pointerPressed(int[] x, int[] y) {
        Display.getInstance().pointerPressed(x, y);
    }

    protected void pointerReleased(int[] x, int[] y) {
        Display.getInstance().pointerReleased(x, y);
    }

    protected void sizeChanged(int w, int h) {
        Display.getInstance().sizeChanged(w, h);
    }

    public void fillRadialGradient(Object graphics, int startColor, int endColor, int x, int y, int width, int height) {
        int sourceR = startColor >> 16 & 0xFF;
        int sourceG = startColor >> 8 & 0xFF;
        int sourceB = startColor & 0xFF;
        int destR = endColor >> 16 & 0xFF;
        int destG = endColor >> 8 & 0xFF;
        int destB = endColor & 0xFF;
        int oldColor = this.getColor(graphics);
        int originalHeight = height;
        while (width > 0 && height > 0) {
            this.updateGradientColor(graphics, sourceR, sourceG, sourceB, destR, destG, destB, originalHeight, height);
            this.fillArc(graphics, x, y, width, height, 0, 360);
            ++x;
            ++y;
            width -= 2;
            height -= 2;
        }
        this.setColor(graphics, oldColor);
    }

    private void updateGradientColor(Object nativeGraphics, int sourceR, int sourceG, int sourceB, int destR, int destG, int destB, int distance, int offset) {
        int r = this.calculateGraidentChannel(sourceR, destR, distance, offset);
        int g = this.calculateGraidentChannel(sourceG, destG, distance, offset);
        int b = this.calculateGraidentChannel(sourceB, destB, distance, offset);
        int color = r << 16 & 0xFF0000 | g << 8 & 0xFF00 | b & 0xFF;
        this.setColor(nativeGraphics, color);
    }

    private int calculateGraidentChannel(int sourceChannel, int destChannel, int distance, int offset) {
        if (sourceChannel == destChannel) {
            return sourceChannel;
        }
        float ratio = (float)offset / (float)distance;
        int pos = (int)((float)Math.abs(sourceChannel - destChannel) * ratio);
        if (sourceChannel > destChannel) {
            return sourceChannel - pos;
        }
        return sourceChannel + pos;
    }

    public void fillLinearGradient(Object graphics, int startColor, int endColor, int x, int y, int width, int height, boolean horizontal) {
        int sourceR = startColor >> 16 & 0xFF;
        int sourceG = startColor >> 8 & 0xFF;
        int sourceB = startColor & 0xFF;
        int destR = endColor >> 16 & 0xFF;
        int destG = endColor >> 8 & 0xFF;
        int destB = endColor & 0xFF;
        int oldColor = this.getColor(graphics);
        if (horizontal) {
            for (int iter = 0; iter < width; ++iter) {
                this.updateGradientColor(graphics, sourceR, sourceG, sourceB, destR, destG, destB, width, iter);
                this.drawLine(graphics, x + iter, y, x + iter, y + height);
            }
        } else {
            for (int iter = 0; iter < height; ++iter) {
                this.updateGradientColor(graphics, sourceR, sourceG, sourceB, destR, destG, destB, height, iter);
                this.drawLine(graphics, x, y + iter, x + width, y + iter);
            }
        }
        this.setColor(graphics, oldColor);
    }

    private boolean checkIntersection(Object g, int y0, int x1, int x2, int y1, int y2, int[] intersections, int intersectionsCount) {
        if (y0 > y1 && y0 < y2 || y0 > y2 && y0 < y1) {
            if (y1 == y2) {
                this.drawLine(g, x1, y0, x2, y0);
                return false;
            }
            intersections[intersectionsCount] = x1 + (int)((float)(y0 - y1) * (float)(x2 - x1) / (float)(y2 - y1));
            return true;
        }
        return false;
    }

    private int markIntersectionEdge(int x1, int y1, int y0, int y2, int[] intersections, int intersectionsCount) {
        intersections[intersectionsCount] = x1;
        if (intersectionsCount + 1 < intersections.length && (y1 <= y0 && y1 <= y2 || y1 >= y0 && y1 >= y2)) {
            intersections[intersectionsCount + 1] = x1;
            return 2;
        }
        return 1;
    }

    public void fillPolygon(Object graphics, int[] xPoints, int[] yPoints, int nPoints) {
        int[] intersections = new int[nPoints];
        int intersectionsCount = 0;
        int yMax = yPoints[0];
        int yMin = yPoints[0];
        for (int i = 0; i < nPoints; ++i) {
            yMax = Math.max(yMax, yPoints[i]);
            yMin = Math.min(yMin, yPoints[i]);
        }
        for (int row = yMin; row <= yMax; ++row) {
            int i;
            intersectionsCount = 0;
            for (int i2 = 1; i2 < nPoints; ++i2) {
                if (!this.checkIntersection(graphics, row, xPoints[i2 - 1], xPoints[i2], yPoints[i2 - 1], yPoints[i2], intersections, intersectionsCount)) continue;
                ++intersectionsCount;
            }
            if (this.checkIntersection(graphics, row, xPoints[nPoints - 1], xPoints[0], yPoints[nPoints - 1], yPoints[0], intersections, intersectionsCount)) {
                ++intersectionsCount;
            }
            for (int j = 0; j < nPoints; ++j) {
                if (row != yPoints[j]) continue;
                if (j == 0) {
                    intersectionsCount += this.markIntersectionEdge(xPoints[0], yPoints[0], yPoints[nPoints - 1], yPoints[1], intersections, intersectionsCount);
                }
                if (j != nPoints - 1) continue;
                intersectionsCount += this.markIntersectionEdge(xPoints[j], yPoints[j], yPoints[j - 1], yPoints[0], intersections, intersectionsCount);
            }
            int swap = 0;
            for (i = 0; i < intersectionsCount; ++i) {
                for (int j = i; j < intersectionsCount; ++j) {
                    if (intersections[j] >= intersections[i]) continue;
                    swap = intersections[i];
                    intersections[i] = intersections[j];
                    intersections[j] = swap;
                }
            }
            for (i = 1; i < intersectionsCount; i += 2) {
                this.drawLine(graphics, intersections[i - 1], row, intersections[i], row);
            }
        }
    }

    public void drawPolygon(Object graphics, int[] xPoints, int[] yPoints, int nPoints) {
        for (int i = 1; i < nPoints; ++i) {
            this.drawLine(graphics, xPoints[i - 1], yPoints[i - 1], xPoints[i], yPoints[i]);
        }
        this.drawLine(graphics, xPoints[nPoints - 1], yPoints[nPoints - 1], xPoints[0], yPoints[0]);
    }

    public void setShowVirtualKeyboard(boolean show) {
    }

    public boolean isVirtualKeyboardShowingSupported() {
        return false;
    }

    public int getKeyboadType() {
        return 0;
    }

    public boolean isNativeInputSupported() {
        return false;
    }

    public boolean isMultiTouch() {
        return false;
    }

    public boolean isClickTouchScreen() {
        return false;
    }
}

